
//Color Filter by Ioxa
//Version 1.0 for ReShade 3.0

#if !defined ActiveColorFilters
	#define ActiveColorFilters 6
#endif

uniform int UseFilter1
<
	ui_type = "drag";
	ui_min = 0; ui_max = 1;
	ui_tooltip = "Set to 1 to use ColorFilter1";
> = 1;

uniform float3 FilterColor1 <
	ui_type = "color";
> = float3(1.000000,0.717647,0.156863);

uniform int BlendMode1
<
	ui_type = "combo";
	ui_items = "None\0Overlay\0Multiply\0SoftLight\0LinearLight\0BurnAndDodge\0WarmScreen\0SoftLight2\0SoftLight3\0Screen\0";
> = 0;

uniform float LowerThreshold1
<
	ui_type = "drag";
	ui_min = 0.000; ui_max = 1.000;
	ui_tooltip = "Filter will not be applied to portions of the original image that are less than this value.";
	ui_step = 0.001;
> = 0.300;

uniform float UpperThreshold1
<
	ui_type = "drag";
	ui_min = 0.000; ui_max = 1.000;
	ui_tooltip = "Filter will not be applied to portions of the original image that are greater than this value.";
	ui_step = 0.001;
> = 0.7;

uniform float ThresholdRange1
<
	ui_type = "drag";
	ui_min = 0.00; ui_max = 1.00;
	ui_tooltip = "Smoothes the transition between the white and black areas of the threshold mask.";
> = 0.500;

uniform float Strength1
<
	ui_type = "drag";
	ui_min = -1.000; ui_max = 1.000;
	ui_tooltip = "Strength of the filter. Positive values add color, negative values remove color.";
	ui_step = 0.001;
> = 0.085;

uniform int DebugMode1
<
	ui_type = "combo";
	ui_items = "None\0ThresholdMask\0Filter\0";
	ui_tooltip = "Helpful for adjusting settings";
> = 0;

#if ActiveColorFilters >= 2
uniform int UseFilter2
<
	ui_type = "drag";
	ui_min = 0; ui_max = 1;
	ui_tooltip = "Set to 1 to use ColorFilter2.";
> = 0;

uniform float3 FilterColor2 <
	ui_type = "color";
> = float3(0.000000,1.000000,0.000000);

uniform int BlendMode2
<
	ui_type = "combo";
	ui_items = "\None\0Overlay\0Multiply\0SoftLight\0LinearLight\0BurnAndDodge\0WarmScreen\0SoftLight2\0SoftLight3\0Screen\0";
	ui_step = 0.20;
> = 0;

uniform float LowerThreshold2
<
	ui_type = "drag";
	ui_min = 0.000; ui_max = 1.000;
	ui_tooltip = "Filter will not be applied to portions of the original image that are less than this value.";
> = 0.000;

uniform float UpperThreshold2
<
	ui_type = "drag";
	ui_min = 0.000; ui_max = 1.000;
	ui_tooltip = "Filter will not be applied to portions of the original image that are greater than this value.";
> = 1.000;

uniform float ThresholdRange2
<
	ui_type = "drag";
	ui_min = 0.00; ui_max = 1.00;
	ui_tooltip = "Smoothes the transition between the white and black areas of the threshold mask.";
> = 0.0;

uniform float Strength2
<
	ui_type = "drag";
	ui_min = -1.00; ui_max = 1.00;
	ui_tooltip = "Strength of the filter. Positive values add color, negative values remove color.";
	ui_step = 0.001;
> = -0.01;

uniform int DebugMode2
<
	ui_type = "combo";
	ui_items = "\None\0ThresholdMask\0Filter\0";
	ui_tooltip = "Helpful for adjusting settings";
> = 0;
#endif

#if ActiveColorFilters >= 3
uniform int UseFilter3
<
	ui_type = "drag";
	ui_min = 0; ui_max = 1;
	ui_tooltip = "Set to 1 to use ColorFilter3.";
> = 0;

uniform float3 FilterColor3 <
	ui_type = "color";
> = float3(0.509804,0.294118,0.000000);

uniform int BlendMode3
<
	ui_type = "combo";
	ui_items = "\None\0Overlay\0Multiply\0SoftLight\0LinearLight\0BurnAndDodge\0WarmScreen\0SoftLight#2\0SoftLight#3\0Screen\0";
> = 3;

uniform float LowerThreshold3
<
	ui_type = "drag";
	ui_min = 0.000; ui_max = 1.000;
	ui_tooltip = "Filter will not be applied to portions of the original image that are less than this value.";
> = 0.200;

uniform float UpperThreshold3
<
	ui_type = "drag";
	ui_min = 0.000; ui_max = 1.000;
	ui_tooltip = "Filter will not be applied to portions of the original image that are greater than this value.";
> = 0.800;

uniform float ThresholdRange3
<
	ui_type = "drag";
	ui_min = 0.00; ui_max = 1.00;
	ui_tooltip = "Smoothes the transition between the white and black areas of the threshold mask.";
> = 0.300;

uniform float Strength3
<
	ui_type = "drag";
	ui_min = -1.00; ui_max = 1.00;
	ui_tooltip = "Strength of the filter. Positive values add color, negative values remove color.";
	ui_step = 0.001;
> = 0.070;

uniform int DebugMode3
<
	ui_type = "combo";
	ui_items = "\None\0ThresholdMask\0Filter\0";
	ui_tooltip = "Helpful for adjusting settings";
> = 0;
#endif 

#if ActiveColorFilters >= 4
uniform int UseFilter4
<
	ui_type = "drag";
	ui_min = 0; ui_max = 1;
	ui_tooltip = "Set to 1 to use ColorFilter4.";
> = 1;

uniform float3 FilterColor4 <
	ui_type = "color";
> = float3(0.000000,0.000000,1.000000);

uniform int BlendMode4
<
	ui_type = "combo";
	ui_items = "\None\0Overlay\0Multiply\0SoftLight\0LinearLight\0BurnAndDodge\0WarmScreen\0SoftLight#2\0SoftLight#3\0Screen\0";
> = 5;

uniform float LowerThreshold4
<
	ui_type = "drag";
	ui_min = 0.000; ui_max = 1.000;
	ui_tooltip = "Filter will not be applied to portions of the original image that are less than this value.";
> = 0.100;

uniform float UpperThreshold4
<
	ui_type = "drag";
	ui_min = 0.000; ui_max = 1.000;
	ui_tooltip = "Filter will not be applied to portions of the original image that are greater than this value.";
> = 0.300;

uniform float ThresholdRange4
<
	ui_type = "drag";
	ui_min = 0.00; ui_max = 1.00;
	ui_tooltip = "Smoothes the transition between the white and black areas of the threshold mask.";
> = 0.300;

uniform float Strength4
<
	ui_type = "drag";
	ui_min = -1.00; ui_max = 1.00;
	ui_tooltip = "Strength of the filter. Positive values add color, negative values remove color.";
	ui_step = 0.001;
> = 0.059;

uniform int DebugMode4
<
	ui_type = "combo";
	ui_items = "\None\0ThresholdMask\0Filter\0";
	ui_tooltip = "Helpful for adjusting settings";
> = 0;
#endif

#if ActiveColorFilters >= 5
uniform int UseFilter5
<
	ui_type = "drag";
	ui_min = 0; ui_max = 1;
	ui_tooltip = "Set to 1 to use ColorFilter5.";
> = 1;

uniform float3 FilterColor5 <
	ui_type = "color";
> = float3(1.000000,0.490196,0.000000);

uniform int BlendMode5
<
	ui_type = "combo";
	ui_items = "\None\0Overlay\0Multiply\0SoftLight\0LinearLight\0BurnAndDodge\0WarmScreen\0SoftLight#2\0SoftLight#3\0Screen\0";
> = 6;

uniform float LowerThreshold5
<
	ui_type = "drag";
	ui_min = 0.000; ui_max = 1.000;
	ui_tooltip = "Filter will not be applied to portions of the original image that are less than this value.";
> = 0.500;

uniform float UpperThreshold5
<
	ui_type = "drag";
	ui_min = 0.000; ui_max = 1.000;
	ui_tooltip = "Filter will not be applied to portions of the original image that are greater than this value.";
> = 0.900;

uniform float ThresholdRange5
<
	ui_type = "drag";
	ui_min = 0.00; ui_max = 1.00;
	ui_tooltip = "Smoothes the transition between the white and black areas of the threshold mask.";
> = 0.500;

uniform float Strength5
<
	ui_type = "drag";
	ui_min = -1.00; ui_max = 1.00;
	ui_tooltip = "Strength of the filter. Positive values add color, negative values remove color.";
	ui_step = 0.001;
> = 0.090;

uniform int DebugMode5
<
	ui_type = "combo";
	ui_items = "\None\0ThresholdMask\0Filter\0";
	ui_tooltip = "Helpful for adjusting settings";
> = 0;
#endif

#if ActiveColorFilters >= 6
uniform int UseFilter6
<
	ui_type = "drag";
	ui_min = 0; ui_max = 1;
	ui_tooltip = "Set to 1 to use ColorFilter6.";
> = 1;

uniform float3 FilterColor6 <
	ui_type = "color";
> = float3(0.039216,0.000000,0.156863);

uniform int BlendMode6
<
	ui_type = "combo";
	ui_items = "\None\0Overlay\0Multiply\0SoftLight\0LinearLight\0BurnAndDodge\0WarmScreen\0SoftLight#2\0SoftLight#3\0Screen\0";
> = 0;

uniform float LowerThreshold6
<
	ui_type = "drag";
	ui_min = 0.000; ui_max = 1.000;
	ui_tooltip = "Filter will not be applied to portions of the original image that are less than this value.";
> = 0.000;

uniform float UpperThreshold6
<
	ui_type = "drag";
	ui_min = 0.000; ui_max = 1.000;
	ui_tooltip = "Filter will not be applied to portions of the original image that are greater than this value.";
> = 0.200;

uniform float ThresholdRange6
<
	ui_type = "drag";
	ui_min = 0.00; ui_max = 1.00;
	ui_tooltip = "Smoothes the transition between the white and black areas of the threshold mask.";
> = 0.220;

uniform float Strength6
<
	ui_type = "drag";
	ui_min = -1.00; ui_max = 1.00;
	ui_tooltip = "Strength of the filter. Positive values add color, negative values remove color.";
	ui_step = 0.001;
> = 0.080;

uniform int DebugMode6
<
	ui_type = "combo";
	ui_items = "\None\0ThresholdMask\0Filter\0";
	ui_tooltip = "Helpful for adjusting settings";
> = 0;
#endif

#if ActiveColorFilters >= 7
uniform int UseFilter7
<
	ui_type = "drag";
	ui_min = 0; ui_max = 1;
	ui_tooltip = "Set to 1 to use ColorFilter7.";
> = 0;

uniform float3 FilterColor7 <
	ui_type = "color";
> = float3(0.039216,0.000000,0.156863);

uniform int BlendMode7
<
	ui_type = "combo";
	ui_items = "\None\0Overlay\0Multiply\0SoftLight\0LinearLight\0BurnAndDodge\0WarmScreen\0SoftLight#2\0SoftLight#3\0Screen\0";
> = 0;

uniform float LowerThreshold7
<
	ui_type = "drag";
	ui_min = 0.000; ui_max = 1.000;
	ui_tooltip = "Filter will not be applied to portions of the original image that are less than this value.";
> = 0.000;

uniform float UpperThreshold7
<
	ui_type = "drag";
	ui_min = 0.000; ui_max = 1.000;
	ui_tooltip = "Filter will not be applied to portions of the original image that are greater than this value.";
> = 0.200;

uniform float ThresholdRange7
<
	ui_type = "drag";
	ui_min = 0.00; ui_max = 1.00;
	ui_tooltip = "Smoothes the transition between the white and black areas of the threshold mask.";
> = 0.220;

uniform float Strength7
<
	ui_type = "drag";
	ui_min = -1.00; ui_max = 1.00;
	ui_tooltip = "Strength of the filter. Positive values add color, negative values remove color.";
	ui_step = 0.001;
> = 0.080;

uniform int DebugMode7
<
	ui_type = "combo";
	ui_items = "\None\0ThresholdMask\0Filter\0";
	ui_tooltip = "Helpful for adjusting settings";
> = 0;
#endif

#if ActiveColorFilters >= 8
uniform int UseFilter8
<
	ui_type = "drag";
	ui_min = 0; ui_max = 1;
	ui_tooltip = "Set to 1 to use ColorFilter8.";
> = 0;

uniform float3 FilterColor8 <
	ui_type = "color";
> = float3(0.039216,0.000000,0.156863);

uniform int BlendMode8
<
	ui_type = "combo";
	ui_items = "\None\0Overlay\0Multiply\0SoftLight\0LinearLight\0BurnAndDodge\0WarmScreen\0SoftLight#2\0SoftLight#3\0Screen\0";
> = 0;

uniform float LowerThreshold8
<
	ui_type = "drag";
	ui_min = 0.000; ui_max = 1.000;
	ui_tooltip = "Filter will not be applied to portions of the original image that are less than this value.";
> = 0.000;

uniform float UpperThreshold8
<
	ui_type = "drag";
	ui_min = 0.000; ui_max = 1.000;
	ui_tooltip = "Filter will not be applied to portions of the original image that are greater than this value.";
> = 0.200;

uniform float ThresholdRange8
<
	ui_type = "drag";
	ui_min = 0.00; ui_max = 1.00;
	ui_tooltip = "Smoothes the transition between the white and black areas of the threshold mask.";
> = 0.220;

uniform float Strength8
<
	ui_type = "drag";
	ui_min = -1.00; ui_max = 1.00;
	ui_tooltip = "Strength of the filter. Positive values add color, negative values remove color.";
	ui_step = 0.001;
> = 0.080;

uniform int DebugMode8
<
	ui_type = "combo";
	ui_items = "\None\0ThresholdMask\0Filter\0";
	ui_tooltip = "Helpful for adjusting settings";
> = 0;
#endif

#if ActiveColorFilters >= 9
uniform int UseFilter9
<
	ui_type = "drag";
	ui_min = 0; ui_max = 1;
	ui_tooltip = "Set to 1 to use ColorFilter9.";
> = 0;

uniform float3 FilterColor9 <
	ui_type = "color";
> = float3(0.039216,0.000000,0.156863);

uniform int BlendMode9
<
	ui_type = "combo";
	ui_items = "\None\0Overlay\0Multiply\0SoftLight\0LinearLight\0BurnAndDodge\0WarmScreen\0SoftLight#2\0SoftLight#3\0Screen\0";
> = 0;

uniform float LowerThreshold9
<
	ui_type = "drag";
	ui_min = 0.000; ui_max = 1.000;
	ui_tooltip = "Filter will not be applied to portions of the original image that are less than this value.";
> = 0.000;

uniform float UpperThreshold9
<
	ui_type = "drag";
	ui_min = 0.000; ui_max = 1.000;
	ui_tooltip = "Filter will not be applied to portions of the original image that are greater than this value.";
> = 0.200;

uniform float ThresholdRange9
<
	ui_type = "drag";
	ui_min = 0.00; ui_max = 1.00;
	ui_tooltip = "Smoothes the transition between the white and black areas of the threshold mask.";
> = 0.220;

uniform float Strength9
<
	ui_type = "drag";
	ui_min = -1.00; ui_max = 1.00;
	ui_tooltip = "Strength of the filter. Positive values add color, negative values remove color.";
	ui_step = 0.001;
> = 0.080;

uniform int DebugMode9
<
	ui_type = "combo";
	ui_items = "\None\0ThresholdMask\0Filter\0";
	ui_tooltip = "Helpful for adjusting settings";
> = 0;
#endif

#if ActiveColorFilters >= 10
uniform int UseFilter10
<
	ui_type = "drag";
	ui_min = 0; ui_max = 1;
	ui_tooltip = "Set to 1 to use ColorFilter10.";
> = 0;

uniform float3 FilterColor10 <
	ui_type = "color";
> = float3(0.039216,0.000000,0.156863);

uniform int BlendMode10
<
	ui_type = "combo";
	ui_items = "\None\0Overlay\0Multiply\0SoftLight\0LinearLight\0BurnAndDodge\0WarmScreen\0SoftLight#2\0SoftLight#3\0Screen\0";
> = 0;

uniform float LowerThreshold10
<
	ui_type = "drag";
	ui_min = 0.000; ui_max = 1.000;
	ui_tooltip = "Filter will not be applied to portions of the original image that are less than this value.";
> = 0.000;

uniform float UpperThreshold10
<
	ui_type = "drag";
	ui_min = 0.000; ui_max = 1.000;
	ui_tooltip = "Filter will not be applied to portions of the original image that are greater than this value.";
> = 0.200;

uniform float ThresholdRange10
<
	ui_type = "drag";
	ui_min = 0.00; ui_max = 1.00;
	ui_tooltip = "Smoothes the transition between the white and black areas of the threshold mask.";
> = 0.220;

uniform float Strength10
<
	ui_type = "drag";
	ui_min = -1.00; ui_max = 1.00;
	ui_tooltip = "Strength of the filter. Positive values add color, negative values remove color.";
	ui_step = 0.001;
> = 0.080;

uniform int DebugMode10
<
	ui_type = "combo";
	ui_items = "\None\0ThresholdMask\0Filter\0";
	ui_tooltip = "Helpful for adjusting settings";
> = 0;
#endif

#include "ReShade.fxh"

float DoThresholdMask(float x, float y, float z, float luma)
{

	float mask = 1.0;
	
	if(x > 0.000)
	{
		mask = lerp(0.0,mask,smoothstep(x-z,x+z,luma));
	}
	
	if(y < 1.000)
	{
		mask = lerp(mask,0.0,smoothstep(y-z,y+z,luma));
	}
	
	return mask;
}

float3 DoBlendMode(float3 A, float3 B, float luma, float Mode)
{
	
	if(Mode == 1)
	{
		//overlay
		A = lerp(2*B*A, 1.0 - 2*(1.0-B)*(1.0-A), step(0.5,luma));
	}
		
	if(Mode == 2)
	{
		//multiply
		A = (2*B*A);
	}
		
	if(Mode == 3)
	{
		//softlight
		A = lerp((2*B-1)*(A-pow(A,2))+A, (2*B-1)*(pow(A,0.5)-A)+A,step(0.501,luma));
	}
	
	if(Mode == 4)
	{
		//linear light
		A = B+2*A-1;
	}
		
	if(Mode == 5)
	{
		//Burn and Dodge
		A = lerp(A+B-1,A+B,smoothstep(0.0,1.0,luma));
	}
		
	if(Mode == 6)
	{
		//screen
		A = 1.0 - (2*(1.0-B)*(1.0-A));
	}
		
	if(Mode == 7)
	{
		//soft light #2
		A = lerp(B*(A+0.5),1-(1-B)*(1-(A-0.5)),step(0.5,A));
	}
		
	if(Mode == 8)
	{
		//soft light #3
		A = lerp((2*A-1)*(B-pow(B,2))+B, ((2*A-1)*(pow(B,0.5)-B))+B, step(0.49,A));
	}
		
	if(Mode == 9)
	{
		//screen
		A = 1.0 - (1.0-B)*(1.0-A);
	}
	
	return saturate(A);
}
float3 FilterBlend(in float4 pos : SV_Position, in float2 texcoord : TEXCOORD) : COLOR
{

	float3 orig = tex2D(ReShade::BackBuffer, texcoord).rgb;
	float luma = dot(orig.rgb,0.333333);

	float3 A;
	float mask;
	
if(UseFilter1)
{

	A = FilterColor1;

	if(BlendMode1)
	{
	A = DoBlendMode(A,orig,luma,BlendMode1);
	}
	
	if( LowerThreshold1 > 0.000 || UpperThreshold1 < 1.000 || DebugMode1 == 1)
	{
		mask = DoThresholdMask(LowerThreshold1,UpperThreshold1,ThresholdRange1,luma);
		A = lerp(orig,A,mask);
		
		if (DebugMode1 == 1)
		{
			A = mask;
			orig = mask;
		}
	}
	
	if(DebugMode1 == 2)
	{
		orig = A;
	}
	
	orig.rgb = lerp(orig.rgb,A,Strength1);
}

#if ActiveColorFilters >= 2
if(UseFilter2)
{

	A = FilterColor2;

	if(BlendMode2)
	{
	A = DoBlendMode(A,orig,luma,BlendMode2);
	}
	
	if( LowerThreshold2 > 0.000 || UpperThreshold2 < 1.000 || DebugMode2 == 1)
	{
		mask = DoThresholdMask(LowerThreshold2,UpperThreshold2,ThresholdRange2,luma);
		A = lerp(orig,A,mask);
		
		if (DebugMode2 == 1)
		{
			A = mask;
			orig = mask;
		}
	}
	
	if(DebugMode2 == 2)
	{
		orig = A;
	}
	
	orig.rgb = lerp(orig.rgb,A,Strength2);
}
#endif 

#if ActiveColorFilters >= 3
if (UseFilter3)
{

	A = FilterColor3;

	if(BlendMode3)
	{
	A = DoBlendMode(A,orig,luma,BlendMode3);
	}
	
	if( LowerThreshold3 > 0.000 || UpperThreshold3 < 1.000 || DebugMode3 == 1)
	{
		mask = DoThresholdMask(LowerThreshold3,UpperThreshold3,ThresholdRange3,luma);
		A = lerp(orig,A,mask);
		
		if (DebugMode3 == 1)
		{
			A = mask;
			orig = mask;
		}
	}
	
	if(DebugMode3 == 2)
	{
		orig = A;
	}
	
	orig.rgb = lerp(orig.rgb,A,Strength3);
}
#endif

#if ActiveColorFilters >= 4
if (UseFilter4)
{

	A = FilterColor4;

	if(BlendMode4)
	{
	A = DoBlendMode(A,orig,luma,BlendMode4);
	}
	
	if( LowerThreshold4 > 0.000 || UpperThreshold4 < 1.000 || DebugMode4 == 1)
	{
		mask = DoThresholdMask(LowerThreshold4,UpperThreshold4,ThresholdRange4,luma);
		A = lerp(orig,A,mask);
		
		if (DebugMode4 == 1)
		{
			A = mask;
			orig = mask;
		}
	}
	
	if(DebugMode4 == 2)
	{
		orig = A;
	}
	
	orig.rgb = lerp(orig.rgb,A,Strength4);
}
#endif

#if ActiveColorFilters >= 5
if (UseFilter5)
{
	A = FilterColor5;
	
	if(BlendMode5)
	{
	A = DoBlendMode(A,orig,luma,BlendMode5);
	}
	
	if( LowerThreshold5 > 0.000 || UpperThreshold5 < 1.000 || DebugMode5 == 1)
	{
		mask = DoThresholdMask(LowerThreshold5,UpperThreshold5,ThresholdRange5,luma);
		A = lerp(orig,A,mask);
		
		if (DebugMode5 == 1)
		{
			A = mask;
			orig = mask;
		}
	}
	
	if(DebugMode5 == 2)
	{
		orig = A;
	}
	
	orig.rgb = lerp(orig.rgb,A,Strength5);
}
#endif

#if ActiveColorFilters >= 6
if (UseFilter6)
{
	A = FilterColor6;
	
	if(BlendMode6)
	{
	A = DoBlendMode(A,orig,luma,BlendMode6);
	}
	
	if( LowerThreshold6 > 0.000 || UpperThreshold6 < 1.000 || DebugMode6 == 1)
	{
		mask = DoThresholdMask(LowerThreshold6,UpperThreshold6,ThresholdRange6,luma);
		A = lerp(orig,A,mask);
		
		if (DebugMode6 == 1)
		{
			A = mask;
			orig = mask;
		}
	}
	
	if(DebugMode6 == 2)
	{
		orig = A;
	}
	
	orig.rgb = lerp(orig.rgb,A,Strength6);
}
#endif

#if ActiveColorFilters >= 7
if (UseFilter7)
{
	A = FilterColor7;
	
	if(BlendMode7)
	{
	A = DoBlendMode(A,orig,luma,BlendMode7);
	}
	
	if( LowerThreshold7 > 0.000 || UpperThreshold7 < 1.000 || DebugMode7 == 1)
	{
		mask = DoThresholdMask(LowerThreshold7,UpperThreshold7,ThresholdRange7,luma);
		A = lerp(orig,A,mask);
		
		if (DebugMode7 == 1)
		{
			A = mask;
			orig = mask;
		}
	}
	
	if(DebugMode7 == 2)
	{
		orig = A;
	}
	
	orig.rgb = lerp(orig.rgb,A,Strength7);
}
#endif

#if ActiveColorFilters >= 8
if (UseFilter8)
{
	A = FilterColor8;
	
	if(BlendMode8)
	{
	A = DoBlendMode(A,orig,luma,BlendMode8);
	}
	
	if( LowerThreshold8 > 0.000 || UpperThreshold8 < 1.000 || DebugMode8 == 1)
	{
		mask = DoThresholdMask(LowerThreshold8,UpperThreshold8,ThresholdRange8,luma);
		A = lerp(orig,A,mask);
		
		if (DebugMode8 == 1)
		{
			A = mask;
			orig = mask;
		}
	}
	
	if(DebugMode8 == 2)
	{
		orig = A;
	}
	
	orig.rgb = lerp(orig.rgb,A,Strength8);
}
#endif

#if ActiveColorFilters >= 9
if (UseFilter9)
{
	A = FilterColor9;
	
	if(BlendMode9)
	{
	A = DoBlendMode(A,orig,luma,BlendMode9);
	}
	
	if( LowerThreshold9 > 0.000 || UpperThreshold9 < 1.000 || DebugMode9 == 1)
	{
		mask = DoThresholdMask(LowerThreshold9,UpperThreshold9,ThresholdRange9,luma);
		A = lerp(orig,A,mask);
		
		if (DebugMode9 == 1)
		{
			A = mask;
			orig = mask;
		}
	}
	
	if(DebugMode9 == 2)
	{
		orig = A;
	}
	
	orig.rgb = lerp(orig.rgb,A,Strength9);
}
#endif

#if ActiveColorFilters >= 10
if (UseFilter10)
{
	A = FilterColor10;
	
	if(BlendMode10)
	{
	A = DoBlendMode(A,orig,luma,BlendMode10);
	}
	
	if( LowerThreshold10 > 0.000 || UpperThreshold10 < 1.000 || DebugMode10 == 1)
	{
		mask = DoThresholdMask(LowerThreshold10,UpperThreshold10,ThresholdRange10,luma);
		A = lerp(orig,A,mask);
		
		if (DebugMode10 == 1)
		{
			A = mask;
			orig = mask;
		}
	}
	
	if(DebugMode10 == 2)
	{
		orig = A;
	}
	
	orig.rgb = lerp(orig.rgb,A,Strength10);
}
#endif

	return saturate(orig.rgb);
}

technique ColorFilter
{

	pass A 
	{
		VertexShader = PostProcessVS;
		PixelShader = FilterBlend;
	}
	
}
